<?php
$clientScript = Yii::app()->clientScript;
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.js');
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.categories.js');
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');

$clientScript->registerScript('chart', <<<CHART_SCRIPT
	var data = new Array();
	var dataObject = $dataJsObject;

	//Display graph
	$.plot($("#placeholder1"), colourBars(dataObject, data), {
		grid:{
			hoverable:true,
		},
		xaxis: {
			mode: "categories",
			tickLength: 0
		},
		bars: {
			show: true,
			barWidth: 0.2,
			order: 1,
		},
		legend: true,
	});

	$("#placeholder1 .flot-x-axis div").each(function(){
		var innerString = $(this).text();
		var tempArray = innerString.split(" ");
		tempArray.pop();
		innerString = tempArray.join(" ");
		$(this).text(innerString);
	});

	//tooltip function
	function showTooltip(x, y, contents, areAbsoluteXY) {
		var rootElt = 'body';

		$('<div id="tooltip2" class="tooltip">' + contents + '</div>').css( {
			position: 'fixed',
			display: 'none',
			top: y - 35,
			left: x - 5,
			'z-index': '9999',
			'color': '#fff',
			'font-size': '11px',
			opacity: 0.8
		}).prependTo(rootElt).show();
	}

	//add tooltip event
	$("#placeholder1").bind("plothover", function (event, pos, item) {
	    if (item) {
		if (previousPoint != item.datapoint) {
		    previousPoint = item.datapoint;

		    //delete de prГ©cГ©dente tooltip
		    $('.tooltip').remove();

		    var x = item.datapoint[0];

		    //All the bars concerning a same x value must display a tooltip with this value and not the shifted value
		    if(item.series.bars.order){
			for(var i=0; i < item.series.data.length; i++){
			    if(item.series.data[i][3] == item.datapoint[0])
				x = item.series.data[i][0];
			}
		    }

		    var y = item.datapoint[1];

		    var categoryName = data[x][0];
		    var tempArray = data[x][0].split(" ");
		    tempArray.pop();
		    categoryName = tempArray.join(" ");
		    showTooltip(item.pageX+5, item.pageY+5,"Klasa: "+categoryName+", Punkty: " + y);
		}
	    }
	    else {
		$('.tooltip').remove();
		previousPoint = null;
	    }

	});
CHART_SCRIPT
, CClientScript::POS_READY);

$this->breadcrumbs = array(
	'Statystyki'
); ?>

<h1>Statystyki</h1>

<div class="bars" id="placeholder1"></div>

<?php
	$this->widget('zii.widgets.grid.CGridView', array(
		'id'=>'parametry-gry-grid',
		'htmlOptions' => array('class' => 'tDefault'),
		'dataProvider'=>$pointsDataProvider,
		'columns'=>array(
			array(
				'name'=>'klasa',
				'header'=>'Klasa',
				'value'=>'\'<a class="buttonS bDefault" style="height: 100%; display: block; text-align: center;" href="\'.Yii::app()->createUrl(\'teacher/main/statistics\',array(\'classId\'=>$data["id"])).\'"><b>\'.$data["klasa"].\'</b></a>\'',
				'type'=>'raw'
			),
			array(
				'name'=>'punkty',
				'header'=>'Punkty',
				'value'=>'$data["punkty"]',
				'type'=>'raw'
			),
		),
	));
?>
